unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMHook, MMDesign, MMObj, MMSlider, MMDIBCv, MMLevel, MMConect, MMWavOut,
  MMWave, MMWaveIO, MMUtils,StdCtrls, MMDSPObj, MMWavIn, MMSystem, MMHTimer;

type
  TForm1 = class(TForm)
    WaveIn: TMMWaveIn;
    btnStopR: TButton;
    btnRecord: TButton;
    WaveFile: TMMWaveFile;
    WaveOut: TMMWaveOut;
    Connector1: TMMConnector;
    Connector2: TMMConnector;
    Level1: TMMLevel;
    Level2: TMMLevel;
    btnStopP: TButton;
    btnPlay: TButton;
    Slider: TMMSlider;
    MMDesigner1: TMMDesigner;
    lblTime: TLabel;
    Timer: TMMHiTimer;
    procedure WaveInOpen(Sender: TObject);
    procedure WaveInClose(Sender: TObject);
    procedure WaveInStart(Sender: TObject);
    procedure WaveInStop(Sender: TObject);
    procedure btnRecordClick(Sender: TObject);
    procedure btnStopRClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopPClick(Sender: TObject);
    procedure SliderTrack(Sender: TObject);
    procedure SliderTrackEnd(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WaveOutStop(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure TimerTimer(Sender: TObject);
  private
  public
    Seeking,Playing: Boolean;
    DataFile: string;
    hFile: THandle;
    StartPos: Longint;
    procedure UpdateControls;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   DataFile := 'G:\DATA.RAW';
   UpdateControls;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { don't forgot to close the devices at the end }
   WaveIn.Close;
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.UpdateControls;
var
   lpwio: PWaveIOCB;
begin
   if FileExists(DataFile) then
   begin
      // clear the file to reload it with the new size
      WaveFile.Wave.FreeWave;

      // build a WaveIO structure so we can build a waveheader in memory
      // we use the format params of WaveIn here because it was recorded with WaveIn
      wioBuildFileInfoFromRAW(lpwio,
                              PChar(DataFile),
                              0,                                 // Offset of the Data , in the rule 0
                              WaveIn.PWaveFormat.wBitsPerSample, // (dest) BitLength
                              WaveIn.PWaveFormat.nChannels,      // number of channels
                              WaveIn.PWaveFormat.nSamplesPerSec);// SampleRate
      if (lpwio <> nil) then
      begin
         { create a wave onthe fly... }
         WaveFile.Wave.PWaveIOInfo := lpwio;
         Slider.MaxValue := WaveFile.Wave.DataSize;
      end;

      btnPlay.Enabled := not WaveFile.Wave.Empty;
      Slider.Enabled  := btnPlay.Enabled;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInOpen(Sender: TObject);
begin
   // WaveIn has opened, create or open the file
   hFile := CreateFile(PChar(DataFile), GENERIC_WRITE, FILE_SHARE_READ or FILE_SHARE_WRITE,
                       nil, OPEN_ALWAYS, 0, 0);
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInClose(Sender: TObject);
begin
   // WaveIn has closed, close the file
   CloseHandle(hFile);
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInStart(Sender: TObject);
begin
   // WaveIn has started, set the position in the file
   if SetFilePointer(hFile, Slider.Position, nil, FILE_BEGIN) = 1 then
      Exception.Create('Unable to Seek !!!');

   btnStopR.Enabled  := True;
   btnRecord.Enabled := False;
   btnPlay.Enabled   := False;

   Slider.Enabled    := False;

   StartPos          := Slider.Position;

   Timer.Enabled     := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInStop(Sender: TObject);
begin
   // WaveIn has stopped, update some controls
   WaveIn.Close;

   Timer.Enabled := False;

   btnStopR.Enabled  := False;
   btnRecord.Enabled := True;
   btnPlay.Enabled   := True;

   UpdateControls;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
var
   nWrite: DWORD;
begin
   // here we received the data from WaveIn, just write it out...
   if not WriteFile(hFile,lpWaveHdr^.lpData,lpWaveHdr^.dwBytesRecorded,nWrite,nil) or
      (nWrite < lpWaveHdr^.dwBytesRecorded) then
   begin
      // this call hangs in the current version
      // but is fixed in the latest and registered version
      // WaveIn.Stop;
      ShowMessage('Unable to write to file, disk full ?');
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnRecordClick(Sender: TObject);
begin
   // start recording
   WaveIn.Start;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopRClick(Sender: TObject);
begin
   // stop recording
   WaveIn.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   if not WaveFile.Wave.Empty then
   begin
      if (Slider.Position >= Slider.MaxValue-100) then
          Slider.Position := 0;

      { set the play position }
      WaveFile.Wave.Position := Slider.Position;

      StartPos          := Slider.Position;

      Seeking := False;

      { start playing }
      WaveOut.Start;

      Playing := True;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopPClick(Sender: TObject);
begin
   // stop the device
   WaveOut.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStart(Sender: TObject);
begin
   btnStopP.Enabled  := True;
   btnPlay.Enabled   := False;
   btnRecord.Enabled := False;
   Timer.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   Timer.Enabled := False;

   // close the device
   WaveOut.Close;

   btnStopP.Enabled  := False;
   btnPlay.Enabled   := True;
   btnRecord.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderTrack(Sender: TObject);
var
   Pos: Longint;
begin
   Seeking := True;
   // we work in bytes but here we need the position in milliseconds
   Pos := wioBytesToTime(WaveIn.PWaveFormat,Slider.Position);
   lblTime.Caption := TimeToString(Pos);
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderTrackEnd(Sender: TObject);
begin
   if Playing then
   begin
      // set the device to pause
      WaveOut.Pause;
      // set new position
      WaveFile.Wave.Position := Slider.Position;
      StartPos               := Slider.Position;

      // reset the device
      WaveOut.Reset;
      // and restart it
      WaveOut.Restart;
   end;
   Seeking := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TimerTimer(Sender: TObject);
var
   Pos: Longint;
begin
   if Playing then
   begin
      if not Seeking then
      begin
         // we work in bytes but here we need the position in milliseconds
         Pos := wioBytesToTime(WaveOut.PWaveFormat,StartPos+WaveOut.Position);
         lblTime.Caption := TimeToString(Pos);

         Slider.Position := WaveFile.Wave.Position;
      end;
   end
   else
   begin
      // we work in bytes but here we need the position in milliseconds
      Pos := wioBytesToTime(WaveIn.PWaveFormat,StartPos+WaveIn.Position);
      lblTime.Caption := TimeToString(Pos);
   end;
end;

end.
